<?php
session_start();
$user = null; // Initialize $user to null

// Check if the user is logged in
if (isset($_SESSION["user_id"])) {
    
    // Connect to the database
    $mysqli = require __DIR__ . "/database.php";
    
    // Use prepared statement to avoid SQL injection and fetch user data safely
    $sql = "SELECT * FROM user WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("i", $_SESSION["user_id"]);
    $stmt->execute();
    $result = $stmt->get_result();
    
    // Fetch the user data
    $user = $result->fetch_assoc();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">

    <title>ArloMusic</title>
    <style>



/* Mobile menu styling */
@media (max-width: 768px) {
    html, body {
    overflow-x: hidden;
    }
       /* Hamburger icon styles */
       .hamburger {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
    padding: 10px;
    z-index: 10; /* Make sure the hamburger icon stays above the menu */
    }

    .hamburger .bar {
    width: 25px;
    height: 3px;
    background-color: white;
    transition: 0.4s;
    }

    .nav-links {
        position: fixed;
        top: 0px;
        right: -60%; /* Start off-screen */
        height: 100vh;
        width: 40%; /* Cover half the screen */
        background-color: #000000c7;
        border-left: 0.5px solid white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        transition: right 0.4s ease; /* Smooth slide-in effect */
        z-index: 9; /* Keep the menu below the hamburger icon */
    }

    .nav-links ul {
        flex-direction: column;
        width: 100%;
    }

    .nav-links ul li {
        display: block;
        padding: 15px 0;
        
    }

    /* Show hamburger icon only on mobile */
    .hamburger {
        display: flex;
    }

    /* When active, slide the menu into view */
    .nav-links.active {
        right: -7%;
        }
    
    .hamburger {
        display: flex;
        position: relative; /* Keeps it at the top right of the screen initially */
        right: 10px;
        z-index: 11; /* Above the menu */
    }

    /* Position hamburger icon "inside" menu when it’s open */
    .hamburger.active {
        position: fixed; /* Repositions icon relative to .nav-links */

        right: 10px;
        z-index: 11; /* Above the sliding menu content */
    }
    .Account{
        margin-left: -20px;
        margin-top: 10px;
    }
}
    </style>
</head>
<body>
    <section class="header" id="NavSection">
        <nav class="navbar">
            <a href="Logged.php"><img class="LogoIcon" src="Images/Logo1.png" alt="ArloMusic_Logo"></a>
            <div class="hamburger" id="hamburger" onclick="toggleMenu()">
        <div class="bar"></div>
        <div class="bar"></div>
        <div class="bar"></div>
            </div>
            <div class="nav-links" id="navLinks">
            
            <ul>
                <li class="navButton"><a href="Logged.php">Home</a></li>
                <li class="navButton"><a href="TopPageLogged.php">Top</a></li>
                <li class="navButton"><a href="ArtistsPage.php">Artists</a></li>
                <li class="navButton"><a href="LogoutSession.php">Log out</a></li>
                <li><a href="AccountInfo.php"><img  class="Account" src="Images/pfp.png" alt="Profile_Picture"></a></li>
                
            </ul>
            
        </div>
        </nav>
        <div class="HeaderLow">
            <h1>
                <?php if ($user): ?>
                    Welcome <?= htmlspecialchars($user['name']) ?>
                <?php else: ?>
                    Welcome, Guest
                <?php endif; ?>
            </h1>
            <p>At ArloMusic, we believe that discovering new music should be as exciting as the music itself. Whether you're searching for the latest tracks from emerging artists or rediscovering forgotten classics, ArloMusic is here to be your personal guide through the world of music.

Explore a rich collection of genres, dive into curated playlists, and uncover talented new artists that match your vibe. From indie sensations to hidden gems, ArloMusic helps you stay ahead of the curve, offering a fresh musical journey with every visit.

Start listening now, and let the music take you places you’ve never been!</p>
            <ul>
                <a href="Logged.php"><button class="btn">Get Started</button></a>
            </ul>
            <br>
        </div>
    </section>

<hr>
    <section class="header2">
        <div class="HeaderLow">
            <h1>More about our goals</h1>
            <p><span class="glow-1">Empowering Emerging Artists</span>: ArloMusic is dedicated to giving up-and-coming musicians the tools and exposure they need to grow their fanbase. Whether you're releasing your first track or fine-tuning your sound, our platform supports artists at every stage of their journey.</p>

            <p><span class="glow-2">Building a Supportive Community</span>: We aim to create an inclusive space where musicians, creators, and listeners can connect and collaborate. Through artist spotlights, interviews, and exclusive content, we bring the stories of independent artists to the forefront.</p>

            <p><span class="glow-3">Creating Opportunities for Exposure</span>: Our goal is to bridge the gap between artists and listeners, connecting musicians with new audiences. Through playlists, promotional opportunities, and partnerships, we strive to shine a light on undiscovered talent, helping them gain the recognition they deserve.</p>

            <p><span class="glow-4">Championing Music Diversity</span>: We celebrate music in all its forms, genres, and styles. From indie rock to electronic beats, from soul to hip-hop, ArloMusic is a platform where diversity thrives, ensuring that unique and fresh voices are heard across the world.</p>
        <ul>
            <a href="ArtistsPage.php"><button class="btn">Share your music</button></a>
        </ul>
        <br>
    </div>
    </section>

<section class="Footer">
    <div class="FooterContent">
        <div class="FooterLinks">
            <ul>
            <li><a href="Logged.php">About Us</a></li>
                    <li><a href="contactLogged.php">Contact Us</a></li>
                    <li><a href="policyLogged.php">Privacy Policy</a></li>
                    <li><a href="TOSlogged.php">Terms of Service</a></li>
            </ul>
        </div>
        <div class="FooterSocials">
            <ul>
                <li><a href=""><img src="Images/facebook.png" alt=""></a></li>
                <li><a href=""><img src="Images/twitter.png" alt=""></a></li>
                <li><a href=""><img src="Images/instagram.png" alt=""></a></li>
            </ul>
        </div>
    </div>
    <h1>Copyright © 2024 ArloMusic All rights reserved.</h1>
</section>
<script>
    function toggleMenu() {
        const navLinks = document.getElementById("navLinks");
        navLinks.classList.toggle("active");
        const hamburger = document.getElementById("hamburger");
        hamburger.classList.toggle("active");
    }
</script>
</body>
</html>